/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.datagen;

import com.epherical.croptopia.Croptopia;
import com.epherical.croptopia.datagen.tags.IndependentEntry;
import com.epherical.croptopia.mixin.datagen.ObjectBuilderAccessor;
import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.register.TagCategory;
import com.epherical.croptopia.register.helpers.FarmlandCrop;
import com.epherical.croptopia.register.helpers.Furnace;
import com.epherical.croptopia.register.helpers.IceCream;
import com.epherical.croptopia.register.helpers.Jam;
import com.epherical.croptopia.register.helpers.Juice;
import com.epherical.croptopia.register.helpers.Pie;
import com.epherical.croptopia.register.helpers.Seafood;
import com.epherical.croptopia.register.helpers.Smoothie;
import com.epherical.croptopia.register.helpers.Tree;
import com.epherical.croptopia.register.helpers.TreeCrop;
import com.epherical.croptopia.register.helpers.Utensil;
import com.epherical.croptopia.util.PluralInfo;
import java.nio.file.Path;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3505;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class CroptopiaIndependentItemTagProvider
extends FabricTagProvider.ItemTagProvider {
    public CroptopiaIndependentItemTagProvider(FabricDataGenerator dataGenerator) {
        super(dataGenerator);
    }

    protected void generateTags() {
        this.generateCrops();
        this.generateSeedsSaplings();
        this.generateOtherEnums();
        this.generateMisc();
    }

    protected void generateCrops() {
        for (FarmlandCrop farmlandCrop : FarmlandCrop.copy()) {
            this.createCategoryTag(farmlandCrop.getTagCategory().getLowerCaseName(), PluralInfo.plural(farmlandCrop.getLowercaseName(), farmlandCrop.hasPlural()), farmlandCrop.method_8389());
            if (farmlandCrop.getTagCategory() == TagCategory.CROPS) continue;
            this.createCategoryTag(TagCategory.CROPS.getLowerCaseName(), PluralInfo.plural(farmlandCrop.getLowercaseName(), farmlandCrop.hasPlural()), farmlandCrop.method_8389());
        }
        for (TreeCrop treeCrop : TreeCrop.copy()) {
            this.createCategoryTag(treeCrop.getTagCategory().getLowerCaseName(), PluralInfo.plural(treeCrop.getLowercaseName(), treeCrop.hasPlural()), treeCrop.method_8389());
            if (treeCrop.getTagCategory() != TagCategory.CROPS) {
                this.createCategoryTag(TagCategory.CROPS.getLowerCaseName(), PluralInfo.plural(treeCrop.getLowercaseName(), treeCrop.hasPlural()), treeCrop.method_8389());
            }
            if (treeCrop.getTagCategory() != TagCategory.NUTS) continue;
            this.createCategoryTag(TagCategory.FRUITS.getLowerCaseName(), PluralInfo.plural(treeCrop.getLowercaseName(), treeCrop.hasPlural()), treeCrop.method_8389());
        }
        for (Tree tree : Tree.copy()) {
            this.createCategoryTag(tree.getTagCategory().getLowerCaseName(), PluralInfo.plural(tree.getLowercaseName(), tree.hasPlural()), tree.method_8389());
        }
    }

    protected void generateSeedsSaplings() {
        for (FarmlandCrop farmlandCrop : FarmlandCrop.copy()) {
            if (farmlandCrop == Content.CHILE_PEPPER) {
                this.createSeedSaplingTag("seeds", "chilepepper", (class_1792)farmlandCrop.getSeedItem());
                continue;
            }
            this.createSeedSaplingTag("seeds", farmlandCrop.getLowercaseName(), (class_1792)farmlandCrop.getSeedItem());
        }
        for (TreeCrop treeCrop : TreeCrop.copy()) {
            this.createSeedSaplingTag("saplings", treeCrop.getLowercaseName(), (class_1792)treeCrop.getSaplingItem());
        }
        for (Tree tree : Tree.copy()) {
            this.createSeedSaplingTag("saplings", tree.getLowercaseName(), tree.getSapling());
        }
    }

    protected void generateOtherEnums() {
        for (Seafood seafood : Seafood.copy()) {
            this.createGeneralTag(seafood.getPlural(), seafood.method_8389());
        }
        for (Furnace furnace : Furnace.copy()) {
            this.createGeneralTag(furnace.getPlural(), furnace.method_8389());
        }
        for (Juice juice : Juice.copy()) {
            this.createCategoryTag("juices", juice.name().toLowerCase() + "s", juice.method_8389());
        }
        for (Jam jam : Jam.copy()) {
            this.createCategoryTag("jams", jam.name().toLowerCase() + "s", jam.method_8389());
        }
        for (Smoothie smoothie : Smoothie.copy()) {
            this.createGeneralTag(smoothie.name().toLowerCase() + "s", smoothie.method_8389());
        }
        for (IceCream iceCream : IceCream.copy()) {
            this.createGeneralTag(iceCream.name().toLowerCase() + "s", iceCream.method_8389());
        }
        for (Pie pie : Pie.copy()) {
            this.createGeneralTag(pie.name().toLowerCase() + "s", pie.method_8389());
        }
        for (Utensil utensil : Utensil.copy()) {
            this.createGeneralTag(utensil.getPlural(), utensil.method_8389());
        }
    }

    protected void generateMisc() {
        this.createGeneralTag("almond_brittles", Content.ALMOND_BRITTLE);
        this.createGeneralTag("artichoke_dips", Content.ARTICHOKE_DIP);
        this.createGeneralTag("banana_cream_pies", Content.BANANA_CREAM_PIE);
        this.createGeneralTag("banana_nut_breads", Content.BANANA_NUT_BREAD);
        this.createGeneralTag("beef_jerkies", Content.BEEF_JERKY);
        this.createGeneralTag("beef_wellington", Content.BEEF_WELLINGTON);
        this.createGeneralTag("beers", Content.BEER);
        this.createGeneralTag("blts", Content.BLT);
        this.createGeneralTag("brownies", Content.BROWNIES);
        this.createGeneralTag("buttered_toasts", Content.BUTTERED_TOAST);
        this.createGeneralTag("butters", Content.BUTTER);
        this.createGeneralTag("caesar_salads", Content.CAESAR_SALAD);
        this.createGeneralTag("candied_nuts", Content.CANDIED_NUTS);
        this.createGeneralTag("candy_corns", Content.CANDY_CORN);
        this.createGeneralTag("cashew_chickens", Content.CASHEW_CHICKEN);
        this.createGeneralTag("cheese_cakes", Content.CHEESE_CAKE);
        this.createGeneralTag("cheese_pizzas", Content.CHEESE_PIZZA);
        this.createGeneralTag("cheeseburgers", Content.CHEESEBURGER);
        this.createGeneralTag("cheeses", Content.CHEESE);
        this.createGeneralTag("chicken_and_dumplings", Content.CHICKEN_AND_DUMPLINGS);
        this.createGeneralTag("chicken_and_noodles", Content.CHICKEN_AND_NOODLES);
        this.createGeneralTag("chicken_and_rice", Content.CHICKEN_AND_RICE);
        this.createGeneralTag("chocolate_milkshakes", Content.CHOCOLATE_MILKSHAKE);
        this.createGeneralTag("chocolates", Content.CHOCOLATE);
        this.createGeneralTag("coffees", Content.COFFEE);
        this.createGeneralTag("cornish_pasty", Content.CORNISH_PASTY);
        this.createGeneralTag("cucumber_salads", Content.CUCUMBER_SALAD);
        this.createGeneralTag("doughnuts", Content.DOUGHNUT);
        this.createGeneralTag("doughs", Content.DOUGH);
        this.createGeneralTag("egg_rolls", Content.EGG_ROLL);
        this.createGeneralTag("eton_mess", Content.ETON_MESS);
        this.createGeneralTag("figgy_pudding", Content.FIGGY_PUDDING);
        this.createGeneralTag("fish_and_chips", Content.FISH_AND_CHIPS);
        this.createGeneralTag("flour", Content.FLOUR);
        this.createGeneralTag("french_fries", Content.FRENCH_FRIES);
        this.createGeneralTag("fried_chickens", Content.FRIED_CHICKEN);
        this.createGeneralTag("fruit_salads", Content.FRUIT_SALAD);
        this.createGeneralTag("fruit_smoothies", Content.FRUIT_SMOOTHIE);
        this.createGeneralTag("grilled_cheeses", Content.GRILLED_CHEESE);
        this.createGeneralTag("ham_sandwiches", Content.HAM_SANDWICH);
        this.createGeneralTag("hamburgers", Content.HAMBURGER);
        this.createGeneralTag("kale_chips", Content.KALE_CHIPS);
        this.createGeneralTag("kale_smoothies", Content.KALE_SMOOTHIE);
        this.createGeneralTag("leafy_salads", Content.LEAFY_SALAD);
        this.createGeneralTag("leek_soups", Content.LEEK_SOUP);
        this.createGeneralTag("lemon_chickens", Content.LEMON_CHICKEN);
        this.createGeneralTag("lemonades", Content.LEMONADE);
        this.createGeneralTag("limeades", Content.LIMEADE);
        this.createGeneralTag("meads", Content.MEAD);
        this.createGeneralTag("milk_bottles", Content.MILK_BOTTLE);
        this.createGeneralTag("noodles", Content.NOODLE);
        this.createGeneralTag("nougats", Content.NOUGAT);
        this.createGeneralTag("nutty_cookies", Content.NUTTY_COOKIE);
        this.createGeneralTag("oatmeals", Content.OATMEAL);
        this.createGeneralTag("olive_oils", Content.OLIVE_OIL);
        this.createGeneralTag("onion_rings", Content.ONION_RINGS);
        this.createGeneralTag("paprika", Content.PAPRIKA);
        this.createGeneralTag("peanut_butter_and_jam", Content.PEANUT_BUTTER_AND_JAM);
        this.createGeneralTag("pepperoni", Content.PEPPERONI);
        this.createGeneralTag("pineapple_pepperoni_pizzas", Content.PINEAPPLE_PEPPERONI_PIZZA);
        this.createGeneralTag("pizzas", Content.PIZZA);
        this.createGeneralTag("pork_and_beanss", Content.PORK_AND_BEANS);
        this.createGeneralTag("pork_jerkies", Content.PORK_JERKY);
        this.createGeneralTag("potato_chips", Content.POTATO_CHIPS);
        this.createGeneralTag("protein_bars", Content.PROTEIN_BAR);
        this.createGeneralTag("pumpkin_spice_lattes", Content.PUMPKIN_SPICE_LATTE);
        this.createGeneralTag("raisin_oatmeal_cookies", Content.OATMEAL_COOKIE);
        this.createGeneralTag("ravioli", Content.RAVIOLI);
        this.createGeneralTag("roasted_nuts", Content.ROASTED_NUTS);
        this.createGeneralTag("rum_raisin_ice_creams", Content.RUM_RAISIN_ICE_CREAM);
        this.createGeneralTag("rums", Content.RUM);
        this.createGeneralTag("salsas", Content.SALSA);
        this.createGeneralTag("salt_ores", Content.SALT_ORE);
        this.createGeneralTag("salts", Content.SALT);
        this.createGeneralTag("saucy_chips", Content.SAUCY_CHIPS);
        this.createGeneralTag("scones", Content.SCONES);
        this.createGeneralTag("scrambled_eggs", Content.SCRAMBLED_EGGS);
        this.createGeneralTag("shepherds_pie", Content.SHEPHERDS_PIE);
        this.createGeneralTag("snicker_doodles", Content.SNICKER_DOODLE);
        this.createGeneralTag("soy_milks", Content.SOY_MILK);
        this.createGeneralTag("soy_sauces", Content.SOY_SAUCE);
        this.createGeneralTag("spaghetti_squashs", Content.SPAGHETTI_SQUASH);
        this.createGeneralTag("steamed_rices", Content.STEAMED_RICE);
        this.createGeneralTag("sticky_toffee_pudding", Content.STICKY_TOFFEE_PUDDING);
        this.createGeneralTag("supreme_pizzas", Content.SUPREME_PIZZA);
        this.createGeneralTag("sushis", Content.SUSHI);
        this.createGeneralTag("sweet_potato_friess", Content.SWEET_POTATO_FRIES);
        this.createGeneralTag("tacos", Content.TACO);
        this.createGeneralTag("tea", Content.TEA);
        this.createGeneralTag("toast_with_jam", Content.TOAST_WITH_JAM);
        this.createGeneralTag("tofu", Content.TOFU);
        this.createGeneralTag("tofu_and_dumplings", Content.TOFU_AND_DUMPLINGS);
        this.createGeneralTag("tofuburgers", Content.TOFUBURGER);
        this.createGeneralTag("tortillas", Content.TORTILLA);
        this.createGeneralTag("trail_mixes", Content.TRAIL_MIX);
        this.createGeneralTag("treacle_tarts", Content.TREACLE_TART);
        this.createGeneralTag("trifle", Content.TRIFLE);
        this.createGeneralTag("tuna_sandwiches", Content.TUNA_SANDWICH);
        this.createGeneralTag("veggie_salads", Content.VEGGIE_SALAD);
        this.createGeneralTag("wines", Content.WINE);
        this.createGeneralTag("yam_jam", Content.YAM_JAM);
        this.createGeneralTag("yoghurts", Content.YOGHURT);
        this.createGeneralTag("roasted_pumpkin_seeds", Content.ROASTED_PUMPKIN_SEEDS);
        this.createGeneralTag("roasted_sunflower_seeds", Content.ROASTED_SUNFLOWER_SEEDS);
        this.createGeneralTag("pumpkin_bars", Content.PUMPKIN_BARS);
        this.createGeneralTag("corn_breads", Content.CORN_BREAD);
        this.createGeneralTag("pumpkin_soups", Content.PUMPKIN_SOUP);
        this.createGeneralTag("meringue", Content.MERINGUE);
        this.createGeneralTag("cabbage_rolls", Content.CABBAGE_ROLL);
        this.createGeneralTag("borscht", Content.BORSCHT);
        this.createGeneralTag("goulashes", Content.GOULASH);
        this.createGeneralTag("beetroot_salads", Content.BEETROOT_SALAD);
        this.createGeneralTag("candied_kumquats", Content.CANDIED_KUMQUATS);
        this.createGeneralTag("steamed_crabs", Content.STEAMED_CRAB);
        this.createGeneralTag("sea_lettuce", Content.SEA_LETTUCE);
        this.createGeneralTag("deep_fried_shrimp", Content.DEEP_FRIED_SHRIMP);
        this.createGeneralTag("tuna_rolls", Content.TUNA_ROLL);
        this.createGeneralTag("fried_calamari", Content.FRIED_CALAMARI);
        this.createGeneralTag("crab_legs", Content.CRAB_LEGS);
        this.createGeneralTag("steamed_clams", Content.STEAMED_CLAMS);
        this.createGeneralTag("grilled_oysters", Content.GRILLED_OYSTERS);
        this.createGeneralTag("anchovy_pizzas", Content.ANCHOVY_PIZZA);
        this.createGeneralTag("mashed_potatoes", Content.MASHED_POTATOES);
        this.method_10512(CroptopiaIndependentItemTagProvider.register("water_bottles")).method_26793((Object)Content.WATER_BOTTLE).method_26793((Object)class_1802.field_8705);
        this.method_10512(CroptopiaIndependentItemTagProvider.register("milks")).method_26793((Object)Content.MILK_BOTTLE).method_26793((Object)Content.SOY_MILK).method_26793((Object)class_1802.field_8103);
        this.method_10512(CroptopiaIndependentItemTagProvider.register("potatoes")).method_26793((Object)class_1802.field_8567).method_26793((Object)Content.SWEETPOTATO.method_8389());
    }

    protected Path method_10510(class_2960 id) {
        class_5321 registryKey = this.field_11482.method_30517();
        Path rootOutput = this.field_11483.method_10313();
        return rootOutput.resolve("data/c/" + class_3505.method_40099((class_5321)registryKey) + "/" + id.method_12832() + ".json");
    }

    public void method_10319(class_2408 cache) {
        super.method_10319(cache);
    }

    private static class_6862<class_1792> register(String id) {
        return class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)Croptopia.createIdentifier(id));
    }

    private void createCategoryTag(String category, String name, class_1792 item) {
        String path = class_2378.field_11142.method_10221((Object)item).method_12832();
        class_6862<class_1792> forgeFriendlyTag = CroptopiaIndependentItemTagProvider.register(category + "/" + path);
        IndependentEntry independentEntry = new IndependentEntry(category + "/" + path);
        this.method_10512(forgeFriendlyTag).method_26793((Object)item);
        ObjectBuilderAccessor fabricGeneralTag = (ObjectBuilderAccessor)this.method_10512(CroptopiaIndependentItemTagProvider.register(name)).method_26793((Object)item);
        fabricGeneralTag.getBuilder().method_27064(new class_3494.class_5145((class_3494.class_3496)independentEntry, fabricGeneralTag.getSource()));
        ObjectBuilderAccessor group = (ObjectBuilderAccessor)this.method_10512(CroptopiaIndependentItemTagProvider.register(category));
        IndependentEntry entryForGroup = new IndependentEntry(name);
        group.getBuilder().method_27064(new class_3494.class_5145((class_3494.class_3496)entryForGroup, group.getSource()));
    }

    private FabricTagProvider.FabricTagBuilder createGeneralTag(String name, class_1792 item) {
        class_6862<class_1792> pluralTag = CroptopiaIndependentItemTagProvider.register(name);
        return this.getOrCreateTagBuilder(pluralTag).add((Object)item);
    }

    private void createSeedSaplingTag(String category, String name, class_1792 item) {
        Object pluralSeedName = item == Content.VANILLA.getSeedItem() ? class_2378.field_11142.method_10221((Object)item).method_12832() : class_2378.field_11142.method_10221((Object)item).method_12832() + "s";
        class_6862<class_1792> forgeFriendlyTag = CroptopiaIndependentItemTagProvider.register(category + "/" + name);
        IndependentEntry independentEntry = new IndependentEntry(category + "/" + name);
        this.method_10512(forgeFriendlyTag).method_26793((Object)item);
        ObjectBuilderAccessor group = (ObjectBuilderAccessor)this.method_10512(CroptopiaIndependentItemTagProvider.register(category));
        group.getBuilder().method_27064(new class_3494.class_5145((class_3494.class_3496)independentEntry, group.getSource()));
        ObjectBuilderAccessor fabricGeneralTag = (ObjectBuilderAccessor)this.method_10512(CroptopiaIndependentItemTagProvider.register((String)pluralSeedName)).method_26793((Object)item);
        fabricGeneralTag.getBuilder().method_27064(new class_3494.class_5145((class_3494.class_3496)independentEntry, fabricGeneralTag.getSource()));
    }
}

